#ifndef _MAIN_H
#define _MAIN_H
 
#include "GenericTypeDefs.h"
#include "usb_device.h"
#include "ff.h"
#include "clock.h"
#include "vm.h"

#define FIRMWARE_VERSION						9.92

#define MAIN_DEBUG								0

#define FAST_TASKS_SECS							3

#define SLOW_PERIOD_TASKS_SECS					3
#define SLOW_PERIOD_BATTERY_LOW_RECOVERY_SECS	6

#define NO_INT_NESTING							0
#define NO_LOW_INT_NESTING						1
#define USE_PMDIS								1

#define DL_EE_DIRTY								0x01
#define DL_FILE_DIRTY							0x02
#define DL_DIRTY								(DL_EE_DIRTY | DL_FILE_DIRTY)

#define NO_DATA_LOGGER_MODES					0x00
#define TIME_AUTO_SYNC_MODE						0x01
#define BATTERY_PROTECTION_MODE					0x02
#define SYSTEM_LOGGING_MODE						0x04
#define SYSTEM_LOGGING_TO_UART					0x08
#define SYSTEM_LOGGING_TO_SERIAL_USB			0x10

#define DEFAULT_DATA_LOGGER_LOGGING_MODE		(SYSTEM_LOGGING_MODE | SYSTEM_LOGGING_TO_UART)
#define DEFAULT_DATA_LOGGER_MODE				(SYSTEM_LOGGING_MODE | SYSTEM_LOGGING_TO_UART | TIME_AUTO_SYNC_MODE | BATTERY_PROTECTION_MODE)
#define DEFAULT_PROTECTION_VOLTAGE				(1.80)		/* default voltage below which the battery protection code will be invoked */

#define EE_MAGIC_VALUE							0x76
#define PORS_START								1

#define EE_MAGIC_ADDR							0x00
#define EE_PORS_ADDR							0x04
#define EE_DATA_LOGGER_ADDR						0x10
#define EE_GENERAL_ADDR							0x40

#define CARD_LED_TIMEOUT						3
#define USE_UART								0
#define HOST_ALIVE_TIMEOUT						8
#define HOST_ALIVE_ADDITIONAL_TIMEOUT			6

/* This Allows For Very Slow Computers, when Installing The Driver */

#define HOST_ALIVE_INITIAL_TIMEOUT_LONG			60
#define HOST_ALIVE_INITIAL_TIMEOUT_SHORT		5

#define USB_ENABLED								1
#define TOTAL_ID								0
/* USB Command Set */

#define CMD_SET_CAPTIVE_DEVICE					0x08
#define CMD_GET_CAPTIVE_DEVICE					0x09

#define CMD_GET_VERSION							0x10
#define CMD_POR_RESET							0x13
#define CMD_RESET								0x14
#define CMD_SET_TIME							0x15
#define CMD_GET_TIME							0x16

#define CMD_OPEN_READ_FILE						0x20
#define CMD_OPEN_WRITE_FILE						0x21
#define CMD_READ_FILE							0x22
#define CMD_WRITE_FILE							0x23
#define CMD_CLOSE_FILE							0x24
#define CMD_OPEN_DIR							0x25
#define CMD_READ_DIR							0x26
#define CMD_UNLINK_FILE							0x27
#define CMD_READ_DIR_REWIND						0x28
#define CMD_MKDIR								0x29

#define CMD_INIT_TRANSFERS						0x40
#define CMD_GET_TRANSFER_STATS					0x41
#define CMD_CONTINUE_BULK_TRANSFER_WRITE		0x44 	
#define CMD_CONTINUE_BULK_TRANSFER_READ			0x45
#define	CMD_INIT_DATA_LOGGER_TRANSFER			0x50
#define CMD_INIT_CARDINFO_TRANSFER				0x51
#define CMD_UPDATE_CARD_INFO					0x52
#define CMD_SET_FIRST_POR						0x53

#define CMD_CALL_GLOBAL_FUNCTION_IMMEDIATE		0x70
#define CMD_GET_SERIAL_USB_BUFFER				0x80
#define CMD_INIT_SERIAL_USB_BUFFER				0x81

#define CMD_LOGSTRING							0x90
#define CMD_FLUSH_LOG							0x91
#define CMD_RESTART_LOG							0x92

#define CMD_RESTORE_DEFAULTS					0x94
#define CMD_GET_SIZES							0x95
#define CMD_FLUSH_SETTINGS						0x96
#define CMD_DELETE_LOG							0x97
#define CMD_RECONNECT_MEMORYCARD				0x98
#define CMD_ENTER_SERIAL_BOOTLOADER				0x99
#define CMD_ENTER_USB_BOOTLOADER				0x9A

#define memoryCardSystemUpMacro()				((SDSENSE==SDSENSE_ON)&&(memoryCardSystemUp))

typedef unsigned long  DWORD;
typedef unsigned short WORD;

typedef struct
{
	/* contains all the relevant persistent settings of the data logger */
	/* Dirty must be first, see saveSettings and restoreSettings Files */
	unsigned char					dirty;
	unsigned char					modes;
	unsigned short					pors;
	float							batteryProtectionVoltage;
	TIME_T							lastSyncTime;
	VIRTUAL_MACHINE_ENVIRONMENT		ven;	
	unsigned char					cardLED;
	unsigned char					CRC;
} DATA_LOGGER;

typedef union
{
	DATA_LOGGER 	dataLogger;
	unsigned char  	generalMemory[GENERAL_MEMORY_SIZE];
} DATA_LOGGER_CONTAINER;

char* 							putFileName(char* inptr, const rom char* srcptr);
unsigned long 					showFile(char* fileName, unsigned long totalN, void (*showFunction)(unsigned char* c));
unsigned char* 					getFileNameDataLogger(DATA_LOGGER* dl, unsigned char* fileN);
VM_RETURN_TYPE 					restartLog(void);
void 							readSettings(void);
void 							writeSettings(void);
void 							updateSettings(void);
unsigned char* 					fillPacket(unsigned char* outptr, unsigned int size, unsigned int* todoSize, unsigned char* inptr, unsigned int* done);
void 							initTransfers(void);
void 							ProcessIO(unsigned char usercode);
void				 			ProcessIOTask(unsigned char usercode);
void 							YourHighPriorityISRCode(void);
void				 			YourLowPriorityISRCode(void);
void							IdleTask(void);

void 							setDefaultSettings(DATA_LOGGER* dl);
void 							saveSettingsTask(void);
void 							saveSettingsFileTask(void);
void 							initSettings(DATA_LOGGER* dl);
void 							restoreSettings(DATA_LOGGER* dl);
void 							setPORSettings(DATA_LOGGER* dl);
unsigned int					saveSettings(DATA_LOGGER* dl);
void 							saveSettingsTask(void);
void 							setAllInterrupts(unsigned char c, unsigned char* ptr);
void 							goToSleep(unsigned char c);
void 							logStringRom(const rom unsigned char* instring, unsigned char function);
void 							logStringOnly(unsigned char* instring);
void 							logString(unsigned char* instring, unsigned char function);
void							logF(const rom unsigned char* instring, unsigned char function, float f, unsigned char numdec);
VM_RETURN_TYPE 					flushLog(void);
void 							sleepTime(unsigned char);
unsigned char 					saveSettingsFile(DATA_LOGGER* dl);
unsigned char 					restoreSettingsFile(DATA_LOGGER* dl);
void 							saveSettingsFileTask(void);
unsigned int					syncSettings(DATA_LOGGER* dl);
void 							syncSettingsTask(void);
void 							logVMStats(void);
void							logHeader(void);
void 							setDevicePORs(unsigned long x);
unsigned long 					getDevicePORs(void);
unsigned char					isPOR(void);
void 							mainAppInternal(void);
void							doCheckKeys(unsigned char);
void 							showBuffer(unsigned char* data, unsigned int count);

FRESULT putFileBuffer(FIL* f, unsigned char* data, unsigned int size, unsigned int* done);
FRESULT getFileBuffer(FIL* f, unsigned char* data, unsigned int size, unsigned int* done);
FRESULT flushFileBuffer(FIL* f, unsigned int* done);

extern short					fileIndex;
extern short					fileFull;
extern volatile unsigned char 	memoryCardSystemUp;
extern volatile unsigned char 	memoryCardEjected;
extern unsigned char  			tempString[SIZE_OF_TEMPSTRING];
extern unsigned char			tempStringPtr;
extern FIL	  					fsrc;
extern DIR						fdir;
extern FILINFO					finfo;
extern FATFS 					fileSystem;
extern unsigned int 			transferCounter;	// Used for bulk transfers...
extern unsigned char*   		transferPtr;		// User for bulk transfers...
extern volatile unsigned char 	hostAlive;
extern DATA_LOGGER_CONTAINER	thisUDL;
extern FATFS 					fileSystem;
extern volatile unsigned char 	captiveDevice;
extern unsigned char			firstPor;

#endif
